<?php

if (!urna_vc_is_activated()) {
    return;
}

// Add Simple Line font Icon
if (!function_exists('urna_tbay_add_simple_line_icon_set_to_iconbox')) {
    function urna_tbay_add_simple_line_icon_set_to_iconbox()
    {
        $param = WPBMap::getParam('vc_icon', 'type');
        $param['value'][esc_html__('Simple Line', 'urna')] = 'simpleline';
        $param['weight'] = 90;
        vc_update_shortcode_param('vc_icon', $param);
    }
    add_filter('init', 'urna_tbay_add_simple_line_icon_set_to_iconbox', 40);
}

// Add Simple Line font Icon
if (!function_exists('urna_tbay_add_linearicons_set_to_iconbox')) {
    function urna_tbay_add_linearicons_set_to_iconbox()
    {
        $param = WPBMap::getParam('vc_icon', 'type');
        $param['value'][esc_html__('linear Icons', 'urna')] = 'linearicons';
        $param['weight'] = 90;
        vc_update_shortcode_param('vc_icon', $param);
    }
    add_filter('init', 'urna_tbay_add_linearicons_set_to_iconbox', 50);
}

// Add font picker setting to icon box module when you select your font family from the dropdown
if (!function_exists('urna_tbay_add_font_picker')) {
    function urna_tbay_add_font_picker()
    {
        vc_add_param(
            'vc_icon',
            [
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'urna'),
                'param_name' => 'icon_simpleline',
                'settings' => [
                    'emptyIcon' => true,
                    'type' => 'simpleline',
                    'iconsPerPage' => 400,
                ],
                'value' => 'icon-user',
                'weight' => 80,
                'dependency' => [
                    'element' => 'type',
                    'value' => 'simpleline',
                ],
            ]
        );
        vc_add_param(
            'vc_icon',
            [
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'urna'),
                'param_name' => 'icon_linearicons',
                'settings' => [
                    'emptyIcon' => true,
                    'type' => 'linearicons',
                    'iconsPerPage' => 400,
                ],
                'value' => 'linear-icon-home',
                'weight' => 80,
                'dependency' => [
                    'element' => 'type',
                    'value' => 'linearicons',
                ],
            ]
        );
    }
    add_filter('vc_after_init', 'urna_tbay_add_font_picker', 40);
}
// Add array of your fonts so they can be displayed in the font selector
if (!function_exists('urna_tbay_icon_array')) {
    function urna_tbay_icon_array()
    {
        return [
            ['icon-user' => 'user'],
            ['icon-people' => 'people'],
            ['icon-user-female' => 'user female'],
            ['icon-user-follow' => 'user follow'],
            ['icon-user-following' => 'user following'],
            ['icon-login' => 'login'],
            ['icon-logout' => 'logout'],
            ['icon-emotsmile' => 'emotsmile'],
            ['icon-phone' => 'phone'],
            ['icon-call-end' => 'call end'],
            ['icon-call-in' => 'call in'],
            ['icon-call-out' => 'call out'],
            ['icon-map' => 'call map'],
            ['icon-location-pin' => 'location pin'],
            ['icon-direction' => 'direction'],
            ['icon-directions' => 'directions'],
            ['icon-compass' => 'compass'],
            ['icon-layers' => 'layers'],
            ['icon-list' => 'list'],
            ['icon-options-vertical' => 'options vertical'],
            ['icon-options' => 'options'],
            ['icon-arrow-down' => 'arrow down'],
            ['icon-arrow-left' => 'arrow left'],
            ['icon-arrow-right' => 'arrow right'],
            ['icon-arrow-up' => 'arrow up'],
            ['icon-arrow-up-circle' => 'arrow up circle'],
            ['icon-arrow-left-circle' => 'arrow left circle'],
            ['icon-arrow-right-circle' => 'arrow right circle'],
            ['icon-arrow-down-circle' => 'arrow down circle'],
            ['icon-check' => 'check'],
            ['icon-clock' => 'clock'],
            ['icon-plus' => 'plus'],
            ['icon-minus' => 'minus'],
            ['icon-close' => 'close'],
            ['icon-event' => 'event'],
            ['icon-exclamation' => 'exclamation'],
            ['icon-organization' => 'organization'],
            ['icon-trophy' => 'trophy'],
            ['icon-screen-smartphone' => 'screen smartphone'],
            ['icon-screen-desktop' => 'screen desktop'],
            ['icon-plane' => 'plane'],
            ['icon-notebook' => 'notebook'],
            ['icon-mustache' => 'mustache'],
            ['icon-mouse' => 'mouse'],
            ['icon-magnet' => 'magnet'],
            ['icon-energy' => 'energy'],
            ['icon-disc' => 'disc'],
            ['icon-cursor' => 'cursor'],
            ['icon-cursor-move' => 'cursor move'],
            ['icon-crop' => 'crop'],
            ['icon-chemistry' => 'chemistry'],
            ['icon-speedometer' => 'speedometer'],
            ['icon-shield' => 'shield'],
            ['icon-screen-tablet' => 'screen tablet'],
            ['icon-magic-wand' => 'magic wand'],
            ['icon-hourglass' => 'hourglass'],
            ['icon-graduation' => 'graduation'],
            ['icon-ghost' => 'ghost'],
            ['icon-game-controller' => 'game controller'],
            ['icon-fire' => 'fire'],
            ['icon-eyeglass' => 'eyeglass'],
            ['icon-envelope-open' => 'envelope open'],
            ['icon-envelope-letter' => 'envelope letter'],
            ['icon-bell' => 'bell'],
            ['icon-badge' => 'badge'],
            ['icon-anchor' => 'anchor'],
            ['icon-wallet' => 'wallet'],
            ['icon-vector' => 'vector'],
            ['icon-speech' => 'speech'],
            ['icon-puzzle' => 'puzzle'],
            ['icon-printer' => 'printer'],
            ['icon-present' => 'present'],
            ['icon-playlist' => 'playlist'],
            ['icon-pin' => 'pin'],
            ['icon-picture' => 'picture'],
            ['icon-handbag' => 'handbag'],
            ['icon-globe-alt' => 'globe alt'],
            ['icon-globe' => 'globe'],
            ['icon-folder-alt' => 'folder alt'],
            ['icon-folder' => 'folder'],
            ['icon-film' => 'film'],
            ['icon-feed' => 'feed'],
            ['icon-drop' => 'drop'],
            ['icon-drawer' => 'drawer'],
            ['icon-docs' => 'docs'],
            ['icon-doc' => 'doc'],
            ['icon-diamond' => 'diamond'],
            ['icon-cup' => 'cup'],
            ['icon-calculator' => 'calculator'],
            ['icon-bubbles' => 'bubbles'],
            ['icon-briefcase' => 'briefcase'],
            ['icon-book-open' => 'book open'],
            ['icon-basket-loaded' => 'basket loaded'],
            ['icon-basket' => 'basket'],
            ['icon-bag' => 'bag'],
            ['icon-action-undo' => 'action undo'],
            ['icon-action-redo' => 'action redo'],
            ['icon-wrench' => 'wrench'],
            ['icon-umbrella' => 'umbrella'],
            ['icon-trash' => 'trash'],
            ['icon-tag' => 'tag'],
            ['icon-support' => 'support'],
            ['icon-frame' => 'frame'],
            ['icon-size-fullscreen' => 'size fullscreen'],
            ['icon-size-actual' => 'size actual'],
            ['icon-shuffle' => 'shuffle'],
            ['icon-share-alt' => 'share alt'],
            ['icon-share' => 'share'],
            ['icon-rocket' => 'rocket'],
            ['icon-question' => 'question'],
            ['icon-pie-chart' => 'pie chart'],
            ['icon-pencil' => 'pencil'],
            ['icon-note' => 'note'],
            ['icon-loop' => 'loop'],
            ['icon-home' => 'home'],
            ['icon-grid' => 'grid'],
            ['icon-graph' => 'graph'],
            ['icon-microphone' => 'microphone'],
            ['icon-music-tone-alt' => 'music tone alt'],
            ['icon-music-tone' => 'music tone'],
            ['icon-earphones-alt' => 'earphones alt'],
            ['icon-earphones' => 'earphones'],
            ['icon-equalizer' => 'equalizer'],
            ['icon-like' => 'like'],
            ['icon-dislike' => 'dislike'],
            ['icon-control-start' => 'control start'],
            ['icon-control-rewind' => 'control rewind'],
            ['icon-control-play' => 'control play'],
            ['icon-control-pause' => 'control pause'],
            ['icon-control-forward' => 'control forward'],
            ['icon-control-end' => 'control end'],
            ['icon-control-end' => 'control end'],
            ['icon-volume-1' => 'volume 1'],
            ['icon-volume-2' => 'volume 2'],
            ['icon-volume-off' => 'volume off'],
            ['icon-calendar' => 'calendar'],
            ['icon-bulb' => 'bulb'],
            ['icon-chart' => 'chart'],
            ['icon-ban' => 'ban'],
            ['icon-bubble' => 'bubble'],
            ['icon-camrecorder' => 'camrecorder'],
            ['icon-camera' => 'camera'],
            ['icon-cloud-download' => 'cloud download'],
            ['icon-cloud-upload' => 'cloud upload'],
            ['icon-envelope' => 'envelope'],
            ['icon-eye' => 'eye'],
            ['icon-flag' => 'flag'],
            ['icon-heart' => 'heart'],
            ['icon-info' => 'info'],
            ['icon-key' => 'key'],
            ['icon-link' => 'link'],
            ['icon-lock' => 'lock'],
            ['icon-lock-open' => 'lock open'],
            ['icon-magnifier' => 'magnifier'],
            ['icon-magnifier-add' => 'magnifier add'],
            ['icon-magnifier-remove' => 'magnifier remove'],
            ['icon-paper-clip' => 'paper clip'],
            ['icon-paper-plane' => 'paper plane'],
            ['icon-power' => 'power'],
            ['icon-refresh' => 'refresh'],
            ['icon-reload' => 'reload'],
            ['icon-settings' => 'settings'],
            ['icon-symbol-female' => 'symbol female'],
            ['icon-symbol-male' => 'symbol male'],
            ['icon-target' => 'target'],
            ['icon-credit-card' => 'credit card'],
            ['icon-paypal' => 'paypal'],
            ['icon-social-tumblr' => 'social tumblr'],
            ['icon-social-twitter' => 'social twitter'],
            ['icon-social-facebook' => 'social facebook'],
            ['icon-social-instagram' => 'social instagram'],
            ['icon-social-linkedin' => 'social linkedin'],
            ['icon-social-pinterest' => 'social pinterest'],
            ['icon-social-github' => 'social github'],
            ['icon-social-google' => 'social google'],
            ['icon-social-reddit' => 'social reddit'],
            ['icon-social-skype' => 'social skype'],
            ['icon-social-skype' => 'social skype'],
            ['icon-social-behance' => 'social behance'],
            ['icon-social-foursqare' => 'social foursqare'],
            ['icon-social-soundcloud' => 'social soundcloud'],
            ['icon-social-stumbleupon' => 'social stumbleupon'],
            ['icon-social-youtube' => 'social youtube'],
            ['icon-social-vkontakte' => 'social vkontakte'],
            ['icon-social-steam' => 'social steam'],
        ];
    }
    add_filter('vc_iconpicker-type-simpleline', 'urna_tbay_icon_array');
}

if (!function_exists('urna_tbay_linearicons_array')) {
    function urna_tbay_linearicons_array()
    {
        return [
            ['linear-icon-home' => 'home'],
            ['linear-icon-home2' => 'home2'],
            ['linear-icon-home3' => 'home3'],
            ['linear-icon-home4' => 'home4'],
            ['linear-icon-home5' => 'home5'],
            ['linear-icon-home6' => 'home6'],
            ['linear-icon-bathtub' => 'bathtub'],
            ['linear-icon-toothbrush' => 'toothbrush'],
            ['linear-icon-bed' => 'bed'],
            ['linear-icon-couch' => 'couch'],
            ['linear-icon-chair' => 'chair'],
            ['linear-icon-city' => 'city'],
            ['linear-icon-apartment' => 'apartment'],
            ['linear-icon-pencil' => 'pencil'],
            ['linear-icon-pencil2' => 'pencil2'],
            ['linear-icon-pen' => 'pen'],
            ['linear-icon-pencil3' => 'pencil3'],
            ['linear-icon-eraser' => 'eraser'],
            ['linear-icon-pencil4' => 'pencil4'],
            ['linear-icon-pencil5' => 'pencil5'],
            ['linear-icon-feather' => 'feather'],
            ['linear-icon-feather2' => 'feather2'],
            ['linear-icon-feather3' => 'feather3'],
            ['linear-icon-pen2' => 'pen2'],
            ['linear-icon-pen-add' => 'pen-add'],
            ['linear-icon-pen-remove' => 'pen-remove'],
            ['linear-icon-vector' => 'vector'],
            ['linear-icon-pen3' => 'pen3'],
            ['linear-icon-blog' => 'blog'],
            ['linear-icon-brush' => 'brush'],
            ['linear-icon-brush2' => 'brush2'],
            ['linear-icon-spray' => 'spray'],
            ['linear-icon-paint-roller' => 'paint-roller'],
            ['linear-icon-stamp' => 'stamp'],
            ['linear-icon-tape' => 'tape'],
            ['linear-icon-desk-tape' => 'desk-tape'],
            ['linear-icon-texture' => 'texture'],
            ['linear-icon-eye-dropper' => 'eye-dropper'],
            ['linear-icon-palette' => 'palette'],
            ['linear-icon-color-sampler' => 'color-sampler'],
            ['linear-icon-bucket' => 'bucket'],
            ['linear-icon-gradient' => 'gradient'],
            ['linear-icon-gradient2' => 'gradient2'],
            ['linear-icon-magic-wand' => 'magic-wand'],
            ['linear-icon-magnet' => 'magnet'],
            ['linear-icon-pencil-ruler' => 'pencil-ruler'],
            ['linear-icon-pencil-ruler2' => 'pencil-ruler2'],
            ['linear-icon-compass' => 'compass'],
            ['linear-icon-aim' => 'aim'],
            ['linear-icon-gun' => 'gun'],
            ['linear-icon-bottle' => 'bottle'],
            ['linear-icon-drop' => 'drop'],
            ['linear-icon-drop-crossed' => 'drop-crossed'],
            ['linear-icon-drop2' => 'drop2'],
            ['linear-icon-snow' => 'snow'],
            ['linear-icon-snow2' => 'snow2'],
            ['linear-icon-fire' => 'fire'],
            ['linear-icon-lighter' => 'lighter'],
            ['linear-icon-knife' => 'knife'],
            ['linear-icon-dagger' => 'dagger'],
            ['linear-icon-tissue' => 'tissue'],
            ['linear-icon-toilet-paper' => 'toilet-paper'],
            ['linear-icon-poop' => 'poop'],
            ['linear-icon-umbrella' => 'umbrella'],
            ['linear-icon-umbrella2' => 'umbrella2'],
            ['linear-icon-rain' => 'rain'],
            ['linear-icon-tornado' => 'tornado'],
            ['linear-icon-wind' => 'wind'],
            ['linear-icon-fan' => 'fan'],
            ['linear-icon-contrast' => 'contrast'],
            ['linear-icon-sun-small' => 'sun-small'],
            ['linear-icon-sun' => 'sun'],
            ['linear-icon-sun2' => 'sun2'],
            ['linear-icon-moon' => 'moon'],
            ['linear-icon-cloud' => 'cloud'],
            ['linear-icon-cloud-upload' => 'cloud-upload'],
            ['linear-icon-cloud-download' => 'cloud-download'],
            ['linear-icon-cloud-rain' => 'cloud-rain'],
            ['linear-icon-cloud-hailstones' => 'cloud-hailstones'],
            ['linear-icon-cloud-snow' => 'cloud-snow'],
            ['linear-icon-cloud-windy' => 'cloud-windy'],
            ['linear-icon-sun-wind' => 'sun-wind'],
            ['linear-icon-cloud-fog' => 'cloud-fog'],
            ['linear-icon-cloud-sun' => 'cloud-sun'],
            ['linear-icon-cloud-lightning' => 'cloud-lightning'],
            ['linear-icon-cloud-sync' => 'cloud-sync'],
            ['linear-icon-cloud-lock' => 'cloud-lock'],
            ['linear-icon-cloud-gear' => 'cloud-gear'],
            ['linear-icon-cloud-alert' => 'cloud-alert'],
            ['linear-icon-cloud-check' => 'cloud-check'],
            ['linear-icon-cloud-cross' => 'cloud-cross'],
            ['linear-icon-cloud-crossed' => 'cloud-crossed'],
            ['linear-icon-cloud-database' => 'cloud-database'],
            ['linear-icon-database' => 'database'],
            ['linear-icon-database-add' => 'database-add'],
            ['linear-icon-database-remove' => 'database-remove'],
            ['linear-icon-database-lock' => 'database-lock'],
            ['linear-icon-database-refresh' => 'database-refresh'],
            ['linear-icon-database-check' => 'database-check'],
            ['linear-icon-database-history' => 'database-history'],
            ['linear-icon-database-upload' => 'database-upload'],
            ['linear-icon-database-download' => 'database-download'],
            ['linear-icon-server' => 'server'],
            ['linear-icon-shield' => 'shield'],
            ['linear-icon-shield-check' => 'shield-check'],
            ['linear-icon-shield-alert' => 'shield-alert'],
            ['linear-icon-shield-cross' => 'shield-cross'],
            ['linear-icon-lock' => 'lock'],
            ['linear-icon-rotation-lock' => 'rotation-lock'],
            ['linear-icon-unlock' => 'unlock'],
            ['linear-icon-key' => 'key'],
            ['linear-icon-key-hole' => 'key-hole'],
            ['linear-icon-toggle-off' => 'toggle-off'],
            ['linear-icon-toggle-on' => 'toggle-on'],
            ['linear-icon-cog' => 'cog'],
            ['linear-icon-cog2' => 'cog2'],
            ['linear-icon-wrench' => 'wrench'],
            ['linear-icon-screwdriver' => 'screwdriver'],
            ['linear-icon-hammer-wrench' => 'hammer-wrench'],
            ['linear-icon-hammer' => 'hammer'],
            ['linear-icon-saw' => 'saw'],
            ['linear-icon-axe' => 'axe'],
            ['linear-icon-axe2' => 'axe2'],
            ['linear-icon-shovel' => 'shovel'],
            ['linear-icon-pickaxe' => 'pickaxe'],
            ['linear-icon-factory' => 'factory'],
            ['linear-icon-factory2' => 'factory2'],
            ['linear-icon-recycle' => 'recycle'],
            ['linear-icon-trash' => 'trash'],
            ['linear-icon-trash2' => 'trash2'],
            ['linear-icon-trash3' => 'trash3'],
            ['linear-icon-broom' => 'broom'],
            ['linear-icon-game' => 'game'],
            ['linear-icon-gamepad' => 'gamepad'],
            ['linear-icon-joystick' => 'joystick'],
            ['linear-icon-dice' => 'dice'],
            ['linear-icon-spades' => 'spades'],
            ['linear-icon-diamonds' => 'diamonds'],
            ['linear-icon-clubs' => 'clubs'],
            ['linear-icon-hearts' => 'hearts'],
            ['linear-icon-heart' => 'heart'],
            ['linear-icon-star' => 'star'],
            ['linear-icon-star-half' => 'star-half'],
            ['linear-icon-star-empty' => 'star-empty'],
            ['linear-icon-flag' => 'flag'],
            ['linear-icon-flag2' => 'flag2'],
            ['linear-icon-flag3' => 'flag3'],
            ['linear-icon-mailbox-full' => 'mailbox-full'],
            ['linear-icon-mailbox-empty' => 'mailbox-empty'],
            ['linear-icon-at-sign' => 'at-sign'],
            ['linear-icon-envelope' => 'envelope'],
            ['linear-icon-envelope-open' => 'envelope-open'],
            ['linear-icon-paperclip' => 'paperclip'],
            ['linear-icon-paper-plane' => 'paper-plane'],
            ['linear-icon-reply' => 'reply'],
            ['linear-icon-reply-all' => 'reply-all'],
            ['linear-icon-inbox' => 'inbox'],
            ['linear-icon-inbox2' => 'inbox2'],
            ['linear-icon-outbox' => 'outbox'],
            ['linear-icon-box' => 'box'],
            ['linear-icon-archive' => 'archive'],
            ['linear-icon-archive2' => 'archive2'],
            ['linear-icon-drawers' => 'drawers'],
            ['linear-icon-drawers2' => 'drawers2'],
            ['linear-icon-drawers3' => 'drawers3'],
            ['linear-icon-eye' => 'eye'],
            ['linear-icon-eye-crossed' => 'eye-crossed'],
            ['linear-icon-eye-plus' => 'eye-plus'],
            ['linear-icon-eye-minus' => 'eye-minus'],
            ['linear-icon-binoculars' => 'binoculars'],
            ['linear-icon-binoculars2' => 'binoculars2'],
            ['linear-icon-hdd' => 'hdd'],
            ['linear-icon-hdd-down' => 'hdd-down'],
            ['linear-icon-hdd-up' => 'hdd-up'],
            ['linear-icon-floppy-disk' => 'floppy-disk'],
            ['linear-icon-disc' => 'disc'],
            ['linear-icon-tape2' => 'tape2'],
            ['linear-icon-printer' => 'printer'],
            ['linear-icon-shredder' => 'shredder'],
            ['linear-icon-file-empty' => 'file-empty'],
            ['linear-icon-file-add' => 'file-add'],
            ['linear-icon-file-check' => 'file-check'],
            ['linear-icon-file-lock' => 'file-lock'],
            ['linear-icon-files' => 'files'],
            ['linear-icon-copy' => 'copy'],
            ['linear-icon-compare' => 'compare'],
            ['linear-icon-folder' => 'folder'],
            ['linear-icon-folder-search' => 'folder-search'],
            ['linear-icon-folder-plus' => 'folder-plus'],
            ['linear-icon-folder-minus' => 'folder-minus'],
            ['linear-icon-folder-download' => 'folder-download'],
            ['linear-icon-folder-upload' => 'folder-upload'],
            ['linear-icon-folder-star' => 'folder-star'],
            ['linear-icon-folder-heart' => 'folder-heart'],
            ['linear-icon-folder-user' => 'folder-user'],
            ['linear-icon-folder-shared' => 'folder-shared'],
            ['linear-icon-folder-music' => 'folder-music'],
            ['linear-icon-folder-picture' => 'folder-picture'],
            ['linear-icon-folder-film' => 'folder-film'],
            ['linear-icon-scissors' => 'scissors'],
            ['linear-icon-paste' => 'paste'],
            ['linear-icon-clipboard-empty' => 'clipboard-empty'],
            ['linear-icon-clipboard-pencil' => 'clipboard-pencil'],
            ['linear-icon-clipboard-text' => 'clipboard-text'],
            ['linear-icon-clipboard-check' => 'clipboard-check'],
            ['linear-icon-clipboard-down' => 'clipboard-down'],
            ['linear-icon-clipboard-left' => 'clipboard-left'],
            ['linear-icon-clipboard-alert' => 'clipboard-alert'],
            ['linear-icon-clipboard-user' => 'clipboard-user'],
            ['linear-icon-register' => 'register'],
            ['linear-icon-enter' => 'enter'],
            ['linear-icon-exit' => 'exit'],
            ['linear-icon-papers' => 'papers'],
            ['linear-icon-news' => 'news'],
            ['linear-icon-reading' => 'reading'],
            ['linear-icon-typewriter' => 'typewriter'],
            ['linear-icon-document' => 'document'],
            ['linear-icon-document2' => 'document2'],
            ['linear-icon-graduation-hat' => 'graduation-hat'],
            ['linear-icon-license' => 'license'],
            ['linear-icon-license2' => 'license2'],
            ['linear-icon-medal-empty' => 'medal-empty'],
            ['linear-icon-medal-first' => 'medal-first'],
            ['linear-icon-medal-second' => 'medal-second'],
            ['linear-icon-medal-third' => 'medal-third'],
            ['linear-icon-podium' => 'podium'],
            ['linear-icon-trophy' => 'trophy'],
            ['linear-icon-trophy2' => 'trophy2'],
            ['linear-icon-music-note' => 'music-note'],
            ['linear-icon-music-note2' => 'music-note2'],
            ['linear-icon-music-note3' => 'music-note3'],
            ['linear-icon-playlist' => 'playlist'],
            ['linear-icon-playlist-add' => 'playlist-add'],
            ['linear-icon-guitar' => 'guitar'],
            ['linear-icon-trumpet' => 'trumpet'],
            ['linear-icon-album' => 'album'],
            ['linear-icon-shuffle' => 'shuffle'],
            ['linear-icon-repeat-one' => 'repeat-one'],
            ['linear-icon-repeat' => 'repeat'],
            ['linear-icon-headphones' => 'headphones'],
            ['linear-icon-headset' => 'headset'],
            ['linear-icon-loudspeaker' => 'loudspeaker'],
            ['linear-icon-equalizer' => 'equalizer'],
            ['linear-icon-theater' => 'theater'],
            ['linear-icon-3d-glasses' => '3d-glasses'],
            ['linear-icon-ticket' => 'ticket'],
            ['linear-icon-presentation' => 'presentation'],
            ['linear-icon-play' => 'play'],
            ['linear-icon-film-play' => 'film-play'],
            ['linear-icon-clapboard-play' => 'clapboard-play'],
            ['linear-icon-media' => 'media'],
            ['linear-icon-film' => 'film'],
            ['linear-icon-film2' => 'film2'],
            ['linear-icon-surveillance' => 'surveillance'],
            ['linear-icon-surveillance2' => 'surveillance2'],
            ['linear-icon-camera' => 'camera'],
            ['linear-icon-camera-crossed' => 'camera-crossed'],
            ['linear-icon-camera-play' => 'camera-play'],
            ['linear-icon-time-lapse' => 'time-lapse'],
            ['linear-icon-record' => 'record'],
            ['linear-icon-camera2' => 'camera2'],
            ['linear-icon-camera-flip' => 'camera-flip'],
            ['linear-icon-panorama' => 'panorama'],
            ['linear-icon-time-lapse2' => 'time-lapse2'],
            ['linear-icon-shutter' => 'shutter'],
            ['linear-icon-shutter2' => 'shutter2'],
            ['linear-icon-face-detection' => 'face-detection'],
            ['linear-icon-flare' => 'flare'],
            ['linear-icon-convex' => 'convex'],
            ['linear-icon-concave' => 'concave'],
            ['linear-icon-picture' => 'picture'],
            ['linear-icon-picture2' => 'picture2'],
            ['linear-icon-picture3' => 'picture3'],
            ['linear-icon-pictures' => 'pictures'],
            ['linear-icon-book' => 'book'],
            ['linear-icon-audio-book' => 'audio-book'],
            ['linear-icon-book2' => 'book2'],
            ['linear-icon-bookmark' => 'bookmark'],
            ['linear-icon-bookmark2' => 'bookmark2'],
            ['linear-icon-label' => 'label'],
            ['linear-icon-library' => 'library'],
            ['linear-icon-library2' => 'library2'],
            ['linear-icon-contacts' => 'contacts'],
            ['linear-icon-profile' => 'profile'],
            ['linear-icon-portrait' => 'portrait'],
            ['linear-icon-portrait2' => 'portrait2'],
            ['linear-icon-user' => 'user'],
            ['linear-icon-user-plus' => 'user-plus'],
            ['linear-icon-user-minus' => 'user-minus'],
            ['linear-icon-user-lock' => 'user-lock'],
            ['linear-icon-users' => 'users'],
            ['linear-icon-users2' => 'users2'],
            ['linear-icon-users-plus' => 'users-plus'],
            ['linear-icon-users-minus' => 'users-minus'],
            ['linear-icon-group-work' => 'group-work'],
            ['linear-icon-woman' => 'woman'],
            ['linear-icon-man' => 'man'],
            ['linear-icon-baby' => 'baby'],
            ['linear-icon-baby2' => 'baby2'],
            ['linear-icon-baby3' => 'baby3'],
            ['linear-icon-baby-bottle' => 'baby-bottle'],
            ['linear-icon-walk' => 'walk'],
            ['linear-icon-hand-waving' => 'hand-waving'],
            ['linear-icon-jump' => 'jump'],
            ['linear-icon-run' => 'run'],
            ['linear-icon-woman2' => 'woman2'],
            ['linear-icon-man2' => 'man2'],
            ['linear-icon-man-woman' => 'man-woman'],
            ['linear-icon-height' => 'height'],
            ['linear-icon-weight' => 'weight'],
            ['linear-icon-scale' => 'scale'],
            ['linear-icon-button' => 'button'],
            ['linear-icon-bow-tie' => 'bow-tie'],
            ['linear-icon-tie' => 'tie'],
            ['linear-icon-socks' => 'socks'],
            ['linear-icon-shoe' => 'shoe'],
            ['linear-icon-shoes' => 'shoes'],
            ['linear-icon-hat' => 'hat'],
            ['linear-icon-pants' => 'pants'],
            ['linear-icon-shorts' => 'shorts'],
            ['linear-icon-flip-flops' => 'flip-flops'],
            ['linear-icon-shirt' => 'shirt'],
            ['linear-icon-hanger' => 'hanger'],
            ['linear-icon-laundry' => 'laundry'],
            ['linear-icon-store' => 'store'],
            ['linear-icon-haircut' => 'haircut'],
            ['linear-icon-store-24' => 'store-24'],
            ['linear-icon-barcode' => 'barcode'],
            ['linear-icon-barcode2' => 'barcode2'],
            ['linear-icon-barcode3' => 'barcode3'],
            ['linear-icon-cashier' => 'cashier'],
            ['linear-icon-bag' => 'bag'],
            ['linear-icon-bag2' => 'bag2'],
            ['linear-icon-cart' => 'cart'],
            ['linear-icon-cart-empty' => 'cart-empty'],
            ['linear-icon-cart-full' => 'cart-full'],
            ['linear-icon-cart-plus' => 'cart-plus'],
            ['linear-icon-cart-plus2' => 'cart-plus2'],
            ['linear-icon-cart-add' => 'cart-add'],
            ['linear-icon-cart-remove' => 'cart-remove'],
            ['linear-icon-cart-exchange' => 'cart-exchange'],
            ['linear-icon-tag' => 'tag'],
            ['linear-icon-tags' => 'tags'],
            ['linear-icon-receipt' => 'receipt'],
            ['linear-icon-wallet' => 'wallet'],
            ['linear-icon-credit-card' => 'credit-card'],
            ['linear-icon-cash-dollar' => 'cash-dollar'],
            ['linear-icon-cash-euro' => 'cash-euro'],
            ['linear-icon-cash-pound' => 'cash-pound'],
            ['linear-icon-cash-yen' => 'cash-yen'],
            ['linear-icon-bag-dollar' => 'bag-dollar'],
            ['linear-icon-bag-euro' => 'bag-euro'],
            ['linear-icon-bag-pound' => 'bag-pound'],
            ['linear-icon-bag-yen' => 'bag-yen'],
            ['linear-icon-coin-dollar' => 'coin-dollar'],
            ['linear-icon-coin-euro' => 'coin-euro'],
            ['linear-icon-coin-pound' => 'coin-pound'],
            ['linear-icon-coin-yen' => 'coin-yen'],
            ['linear-icon-calculator' => 'calculator'],
            ['linear-icon-calculator2' => 'calculator2'],
            ['linear-icon-abacus' => 'abacus'],
            ['linear-icon-vault' => 'vault'],
            ['linear-icon-telephone' => 'telephone'],
            ['linear-icon-phone-lock' => 'phone-lock'],
            ['linear-icon-phone-wave' => 'phone-wave'],
            ['linear-icon-phone-pause' => 'phone-pause'],
            ['linear-icon-phone-outgoing' => 'phone-outgoing'],
            ['linear-icon-phone-incoming' => 'phone-incoming'],
            ['linear-icon-phone-in-out' => 'phone-in-out'],
            ['linear-icon-phone-error' => 'phone-error'],
            ['linear-icon-phone-sip' => 'phone-sip'],
            ['linear-icon-phone-plus' => 'phone-plus'],
            ['linear-icon-phone-minus' => 'phone-minus'],
            ['linear-icon-voicemail' => 'voicemail'],
            ['linear-icon-dial' => 'dial'],
            ['linear-icon-telephone2' => 'telephone2'],
            ['linear-icon-pushpin' => 'pushpin'],
            ['linear-icon-pushpin2' => 'pushpin2'],
            ['linear-icon-map-marker' => 'map-marker'],
            ['linear-icon-map-marker-user' => 'map-marker-user'],
            ['linear-icon-map-marker-down' => 'map-marker-down'],
            ['linear-icon-map-marker-check' => 'map-marker-check'],
            ['linear-icon-map-marker-crossed' => 'map-marker-crossed'],
            ['linear-icon-radar' => 'radar'],
            ['linear-icon-compass2' => 'compass2'],
            ['linear-icon-map' => 'map'],
            ['linear-icon-map2' => 'map2'],
            ['linear-icon-location' => 'location'],
            ['linear-icon-road-sign' => 'road-sign'],
            ['linear-icon-calendar-empty' => 'calendar-empty'],
            ['linear-icon-calendar-check' => 'calendar-check'],
            ['linear-icon-calendar-cross' => 'calendar-cross'],
            ['linear-icon-calendar-31' => 'calendar-31'],
            ['linear-icon-calendar-full' => 'calendar-full'],
            ['linear-icon-calendar-insert' => 'calendar-insert'],
            ['linear-icon-calendar-text' => 'calendar-text'],
            ['linear-icon-calendar-user' => 'calendar-user'],
            ['linear-icon-mouse' => 'mouse'],
            ['linear-icon-mouse-left' => 'mouse-left'],
            ['linear-icon-mouse-right' => 'mouse-right'],
            ['linear-icon-mouse-both' => 'mouse-both'],
            ['linear-icon-keyboard' => 'keyboard'],
            ['linear-icon-keyboard-up' => 'keyboard-up'],
            ['linear-icon-keyboard-down' => 'keyboard-down'],
            ['linear-icon-delete' => 'delete'],
            ['linear-icon-spell-check' => 'spell-check'],
            ['linear-icon-escape' => 'escape'],
            ['linear-icon-enter2' => 'enter2'],
            ['linear-icon-screen' => 'screen'],
            ['linear-icon-aspect-ratio' => 'aspect-ratio'],
            ['linear-icon-signal' => 'signal'],
            ['linear-icon-signal-lock' => 'signal-lock'],
            ['linear-icon-signal-80' => 'signal-80'],
            ['linear-icon-signal-60' => 'signal-60'],
            ['linear-icon-signal-40' => 'signal-40'],
            ['linear-icon-signal-20' => 'signal-20'],
            ['linear-icon-signal-0' => 'signal-0'],
            ['linear-icon-signal-blocked' => 'signal-blocked'],
            ['linear-icon-sim' => 'sim'],
            ['linear-icon-flash-memory' => 'flash-memory'],
            ['linear-icon-usb-drive' => 'usb-drive'],
            ['linear-icon-phone' => 'phone'],
            ['linear-icon-smartphone' => 'smartphone'],
            ['linear-icon-smartphone-notification' => 'smartphone-notification'],
            ['linear-icon-smartphone-vibration' => 'smartphone-vibration'],
            ['linear-icon-smartphone-embed' => 'smartphone-embed'],
            ['linear-icon-smartphone-waves' => 'smartphone-waves'],
            ['linear-icon-tablet' => 'tablet'],
            ['linear-icon-tablet2' => 'tablet2'],
            ['linear-icon-laptop' => 'laptop'],
            ['linear-icon-laptop-phone' => 'laptop-phone'],
            ['linear-icon-desktop' => 'desktop'],
            ['linear-icon-launch' => 'launch'],
            ['linear-icon-new-tab' => 'new-tab'],
            ['linear-icon-window' => 'window'],
            ['linear-icon-cable' => 'cable'],
            ['linear-icon-cable2' => 'cable2'],
            ['linear-icon-tv' => 'tv'],
            ['linear-icon-radio' => 'radio'],
            ['linear-icon-remote-control' => 'remote-control'],
            ['linear-icon-power-switch' => 'power-switch'],
            ['linear-icon-power' => 'power'],
            ['linear-icon-power-crossed' => 'power-crossed'],
            ['linear-icon-flash-auto' => 'flash-auto'],
            ['linear-icon-lamp' => 'lamp'],
            ['linear-icon-flashlight' => 'flashlight'],
            ['linear-icon-lampshade' => 'lampshade'],
            ['linear-icon-cord' => 'cord'],
            ['linear-icon-outlet' => 'outlet'],
            ['linear-icon-battery-power' => 'battery-power'],
            ['linear-icon-battery-empty' => 'battery-empty'],
            ['linear-icon-battery-alert' => 'battery-alert'],
            ['linear-icon-battery-error' => 'battery-error'],
            ['linear-icon-battery-low1' => 'battery-low1'],
            ['linear-icon-battery-low2' => 'battery-low2'],
            ['linear-icon-battery-low3' => 'battery-low3'],
            ['linear-icon-battery-mid1' => 'battery-mid1'],
            ['linear-icon-battery-mid2' => 'battery-mid2'],
            ['linear-icon-battery-mid3' => 'battery-mid3'],
            ['linear-icon-battery-full' => 'battery-full'],
            ['linear-icon-battery-charging' => 'battery-charging'],
            ['linear-icon-battery-charging2' => 'battery-charging2'],
            ['linear-icon-battery-charging3' => 'battery-charging3'],
            ['linear-icon-battery-charging4' => 'battery-charging4'],
            ['linear-icon-battery-charging5' => 'battery-charging5'],
            ['linear-icon-battery-charging6' => 'battery-charging6'],
            ['linear-icon-battery-charging7' => 'battery-charging7'],
            ['linear-icon-chip' => 'chip'],
            ['linear-icon-chip-x64' => 'chip-x64'],
            ['linear-icon-chip-x86' => 'chip-x86'],
            ['linear-icon-bubble' => 'bubble'],
            ['linear-icon-bubbles' => 'bubbles'],
            ['linear-icon-bubble-dots' => 'bubble-dots'],
            ['linear-icon-bubble-alert' => 'bubble-alert'],
            ['linear-icon-bubble-question' => 'bubble-question'],
            ['linear-icon-bubble-text' => 'bubble-text'],
            ['linear-icon-bubble-pencil' => 'bubble-pencil'],
            ['linear-icon-bubble-picture' => 'bubble-picture'],
            ['linear-icon-bubble-video' => 'bubble-video'],
            ['linear-icon-bubble-user' => 'bubble-user'],
            ['linear-icon-bubble-quote' => 'bubble-quote'],
            ['linear-icon-bubble-heart' => 'bubble-heart'],
            ['linear-icon-bubble-emoticon' => 'bubble-emoticon'],
            ['linear-icon-bubble-attachment' => 'bubble-attachment'],
            ['linear-icon-phone-bubble' => 'phone-bubble'],
            ['linear-icon-quote-open' => 'quote-open'],
            ['linear-icon-quote-close' => 'quote-close'],
            ['linear-icon-dna' => 'dna'],
            ['linear-icon-heart-pulse' => 'heart-pulse'],
            ['linear-icon-pulse' => 'pulse'],
            ['linear-icon-syringe' => 'syringe'],
            ['linear-icon-pills' => 'pills'],
            ['linear-icon-first-aid' => 'first-aid'],
            ['linear-icon-lifebuoy' => 'lifebuoy'],
            ['linear-icon-bandage' => 'bandage'],
            ['linear-icon-bandages' => 'bandages'],
            ['linear-icon-thermometer' => 'thermometer'],
            ['linear-icon-microscope' => 'microscope'],
            ['linear-icon-brain' => 'brain'],
            ['linear-icon-beaker' => 'beaker'],
            ['linear-icon-skull' => 'skull'],
            ['linear-icon-bone' => 'bone'],
            ['linear-icon-construction' => 'construction'],
            ['linear-icon-construction-cone' => 'construction-cone'],
            ['linear-icon-pie-chart' => 'pie-chart'],
            ['linear-icon-pie-chart2' => 'pie-chart2'],
            ['linear-icon-graph' => 'graph'],
            ['linear-icon-chart-growth' => 'chart-growth'],
            ['linear-icon-chart-bars' => 'chart-bars'],
            ['linear-icon-chart-settings' => 'chart-settings'],
            ['linear-icon-cake' => 'cake'],
            ['linear-icon-gift' => 'gift'],
            ['linear-icon-balloon' => 'balloon'],
            ['linear-icon-rank' => 'rank'],
            ['linear-icon-rank2' => 'rank2'],
            ['linear-icon-rank3' => 'rank3'],
            ['linear-icon-crown' => 'crown'],
            ['linear-icon-lotus' => 'lotus'],
            ['linear-icon-diamond' => 'diamond'],
            ['linear-icon-diamond2' => 'diamond2'],
            ['linear-icon-diamond3' => 'diamond3'],
            ['linear-icon-diamond4' => 'diamond4'],
            ['linear-icon-linearicons' => 'linearicons'],
            ['linear-icon-teacup' => 'teacup'],
            ['linear-icon-teapot' => 'teapot'],
            ['linear-icon-glass' => 'glass'],
            ['linear-icon-bottle2' => 'bottle2'],
            ['linear-icon-glass-cocktail' => 'glass-cocktail'],
            ['linear-icon-glass2' => 'glass2'],
            ['linear-icon-dinner' => 'dinner'],
            ['linear-icon-dinner2' => 'dinner2'],
            ['linear-icon-chef' => 'chef'],
            ['linear-icon-scale2' => 'scale2'],
            ['linear-icon-egg' => 'egg'],
            ['linear-icon-egg2' => 'egg2'],
            ['linear-icon-eggs' => 'eggs'],
            ['linear-icon-platter' => 'platter'],
            ['linear-icon-steak' => 'steak'],
            ['linear-icon-hamburger' => 'hamburger'],
            ['linear-icon-hotdog' => 'hotdog'],
            ['linear-icon-pizza' => 'pizza'],
            ['linear-icon-sausage' => 'sausage'],
            ['linear-icon-chicken' => 'chicken'],
            ['linear-icon-fish' => 'fish'],
            ['linear-icon-carrot' => 'carrot'],
            ['linear-icon-cheese' => 'cheese'],
            ['linear-icon-bread' => 'bread'],
            ['linear-icon-ice-cream' => 'ice-cream'],
            ['linear-icon-ice-cream2' => 'ice-cream2'],
            ['linear-icon-candy' => 'candy'],
            ['linear-icon-lollipop' => 'lollipop'],
            ['linear-icon-coffee-bean' => 'coffee-bean'],
            ['linear-icon-coffee-cup' => 'coffee-cup'],
            ['linear-icon-cherry' => 'cherry'],
            ['linear-icon-grapes' => 'grapes'],
            ['linear-icon-citrus' => 'citrus'],
            ['linear-icon-apple' => 'apple'],
            ['linear-icon-leaf' => 'leaf'],
            ['linear-icon-landscape' => 'landscape'],
            ['linear-icon-pine-tree' => 'pine-tree'],
            ['linear-icon-tree' => 'tree'],
            ['linear-icon-cactus' => 'cactus'],
            ['linear-icon-paw' => 'paw'],
            ['linear-icon-footprint' => 'footprint'],
            ['linear-icon-speed-slow' => 'speed-slow'],
            ['linear-icon-speed-medium' => 'speed-medium'],
            ['linear-icon-speed-fast' => 'speed-fast'],
            ['linear-icon-rocket' => 'rocket'],
            ['linear-icon-hammer2' => 'hammer2'],
            ['linear-icon-balance' => 'balance'],
            ['linear-icon-briefcase' => 'briefcase'],
            ['linear-icon-luggage-weight' => 'luggage-weight'],
            ['linear-icon-dolly' => 'dolly'],
            ['linear-icon-plane' => 'plane'],
            ['linear-icon-plane-crossed' => 'plane-crossed'],
            ['linear-icon-helicopter' => 'helicopter'],
            ['linear-icon-traffic-lights' => 'traffic-lights'],
            ['linear-icon-siren' => 'siren'],
            ['linear-icon-road' => 'road'],
            ['linear-icon-engine' => 'engine'],
            ['linear-icon-oil-pressure' => 'oil-pressure'],
            ['linear-icon-coolant-temperature' => 'coolant-temperature'],
            ['linear-icon-car-battery' => 'car-battery'],
            ['linear-icon-gas' => 'gas'],
            ['linear-icon-gallon' => 'gallon'],
            ['linear-icon-transmission' => 'transmission'],
            ['linear-icon-car' => 'car'],
            ['linear-icon-car-wash' => 'car-wash'],
            ['linear-icon-car-wash2' => 'car-wash2'],
            ['linear-icon-bus' => 'bus'],
            ['linear-icon-bus2' => 'bus2'],
            ['linear-icon-car2' => 'car2'],
            ['linear-icon-parking' => 'parking'],
            ['linear-icon-car-lock' => 'car-lock'],
            ['linear-icon-taxi' => 'taxi'],
            ['linear-icon-car-siren' => 'car-siren'],
            ['linear-icon-car-wash3' => 'car-wash3'],
            ['linear-icon-car-wash4' => 'car-wash4'],
            ['linear-icon-ambulance' => 'ambulance'],
            ['linear-icon-truck' => 'truck'],
            ['linear-icon-trailer' => 'trailer'],
            ['linear-icon-scale-truck' => 'scale-truck'],
            ['linear-icon-train' => 'train'],
            ['linear-icon-ship' => 'ship'],
            ['linear-icon-ship2' => 'ship2'],
            ['linear-icon-anchor' => 'anchor'],
            ['linear-icon-boat' => 'boat'],
            ['linear-icon-bicycle' => 'bicycle'],
            ['linear-icon-bicycle2' => 'bicycle2'],
            ['linear-icon-dumbbell' => 'dumbbell'],
            ['linear-icon-bench-press' => 'bench-press'],
            ['linear-icon-swim' => 'swim'],
            ['linear-icon-football' => 'football'],
            ['linear-icon-baseball-bat' => 'baseball-bat'],
            ['linear-icon-baseball' => 'baseball'],
            ['linear-icon-tennis' => 'tennis'],
            ['linear-icon-tennis2' => 'tennis2'],
            ['linear-icon-ping-pong' => 'ping-pong'],
            ['linear-icon-hockey' => 'hockey'],
            ['linear-icon-8ball' => '8ball'],
            ['linear-icon-bowling' => 'bowling'],
            ['linear-icon-bowling-pins' => 'bowling-pins'],
            ['linear-icon-golf' => 'golf'],
            ['linear-icon-golf2' => 'golf2'],
            ['linear-icon-archery' => 'archery'],
            ['linear-icon-slingshot' => 'slingshot'],
            ['linear-icon-soccer' => 'soccer'],
            ['linear-icon-basketball' => 'basketball'],
            ['linear-icon-cube' => 'cube'],
            ['linear-icon-3d-rotate' => '3d-rotate'],
            ['linear-icon-puzzle' => 'puzzle'],
            ['linear-icon-glasses' => 'glasses'],
            ['linear-icon-glasses2' => 'glasses2'],
            ['linear-icon-accessibility' => 'accessibility'],
            ['linear-icon-wheelchair' => 'wheelchair'],
            ['linear-icon-wall' => 'wall'],
            ['linear-icon-fence' => 'fence'],
            ['linear-icon-wall2' => 'wall2'],
            ['linear-icon-icons' => 'icons'],
            ['linear-icon-resize-handle' => 'resize-handle'],
            ['linear-icon-icons2' => 'icons2'],
            ['linear-icon-select' => 'select'],
            ['linear-icon-select2' => 'select2'],
            ['linear-icon-site-map' => 'site-map'],
            ['linear-icon-earth' => 'earth'],
            ['linear-icon-earth-lock' => 'earth-lock'],
            ['linear-icon-network' => 'network'],
            ['linear-icon-network-lock' => 'network-lock'],
            ['linear-icon-planet' => 'planet'],
            ['linear-icon-happy' => 'happy'],
            ['linear-icon-smile' => 'smile'],
            ['linear-icon-grin' => 'grin'],
            ['linear-icon-tongue' => 'tongue'],
            ['linear-icon-sad' => 'sad'],
            ['linear-icon-wink' => 'wink'],
            ['linear-icon-dream' => 'dream'],
            ['linear-icon-shocked' => 'shocked'],
            ['linear-icon-shocked2' => 'shocked2'],
            ['linear-icon-tongue2' => 'tongue2'],
            ['linear-icon-neutral' => 'neutral'],
            ['linear-icon-happy-grin' => 'happy-grin'],
            ['linear-icon-cool' => 'cool'],
            ['linear-icon-mad' => 'mad'],
            ['linear-icon-grin-evil' => 'grin-evil'],
            ['linear-icon-evil' => 'evil'],
            ['linear-icon-wow' => 'wow'],
            ['linear-icon-annoyed' => 'annoyed'],
            ['linear-icon-wondering' => 'wondering'],
            ['linear-icon-confused' => 'confused'],
            ['linear-icon-zipped' => 'zipped'],
            ['linear-icon-grumpy' => 'grumpy'],
            ['linear-icon-mustache' => 'mustache'],
            ['linear-icon-tombstone-hipster' => 'tombstone-hipster'],
            ['linear-icon-tombstone' => 'tombstone'],
            ['linear-icon-ghost' => 'ghost'],
            ['linear-icon-ghost-hipster' => 'ghost-hipster'],
            ['linear-icon-halloween' => 'halloween'],
            ['linear-icon-christmas' => 'christmas'],
            ['linear-icon-easter-egg' => 'easter-egg'],
            ['linear-icon-mustache2' => 'mustache2'],
            ['linear-icon-mustache-glasses' => 'mustache-glasses'],
            ['linear-icon-pipe' => 'pipe'],
            ['linear-icon-alarm' => 'alarm'],
            ['linear-icon-alarm-add' => 'alarm-add'],
            ['linear-icon-alarm-snooze' => 'alarm-snooze'],
            ['linear-icon-alarm-ringing' => 'alarm-ringing'],
            ['linear-icon-bullhorn' => 'bullhorn'],
            ['linear-icon-hearing' => 'hearing'],
            ['linear-icon-volume-high' => 'volume-high'],
            ['linear-icon-volume-medium' => 'volume-medium'],
            ['linear-icon-volume-low' => 'volume-low'],
            ['linear-icon-volume' => 'volume'],
            ['linear-icon-mute' => 'mute'],
            ['linear-icon-lan' => 'lan'],
            ['linear-icon-lan2' => 'lan2'],
            ['linear-icon-wifi' => 'wifi'],
            ['linear-icon-wifi-lock' => 'wifi-lock'],
            ['linear-icon-wifi-blocked' => 'wifi-blocked'],
            ['linear-icon-wifi-mid' => 'wifi-mid'],
            ['linear-icon-wifi-low' => 'wifi-low'],
            ['linear-icon-wifi-low2' => 'wifi-low2'],
            ['linear-icon-wifi-alert' => 'wifi-alert'],
            ['linear-icon-wifi-alert-mid' => 'wifi-alert-mid'],
            ['linear-icon-wifi-alert-low' => 'wifi-alert-low'],
            ['linear-icon-wifi-alert-low2' => 'wifi-alert-low2'],
            ['linear-icon-stream' => 'stream'],
            ['linear-icon-stream-check' => 'stream-check'],
            ['linear-icon-stream-error' => 'stream-error'],
            ['linear-icon-stream-alert' => 'stream-alert'],
            ['linear-icon-communication' => 'communication'],
            ['linear-icon-communication-crossed' => 'communication-crossed'],
            ['linear-icon-broadcast' => 'broadcast'],
            ['linear-icon-antenna' => 'antenna'],
            ['linear-icon-satellite' => 'satellite'],
            ['linear-icon-satellite2' => 'satellite2'],
            ['linear-icon-mic' => 'mic'],
            ['linear-icon-mic-mute' => 'mic-mute'],
            ['linear-icon-mic2' => 'mic2'],
            ['linear-icon-spotlights' => 'spotlights'],
            ['linear-icon-hourglass' => 'hourglass'],
            ['linear-icon-loading' => 'loading'],
            ['linear-icon-loading2' => 'loading2'],
            ['linear-icon-loading3' => 'loading3'],
            ['linear-icon-refresh' => 'refresh'],
            ['linear-icon-refresh2' => 'refresh2'],
            ['linear-icon-undo' => 'undo'],
            ['linear-icon-redo' => 'redo'],
            ['linear-icon-jump2' => 'jump2'],
            ['linear-icon-undo2' => 'undo2'],
            ['linear-icon-redo2' => 'redo2'],
            ['linear-icon-sync' => 'sync'],
            ['linear-icon-repeat-one2' => 'repeat-one2'],
            ['linear-icon-sync-crossed' => 'sync-crossed'],
            ['linear-icon-sync2' => 'sync2'],
            ['linear-icon-repeat-one3' => 'repeat-one3'],
            ['linear-icon-sync-crossed2' => 'sync-crossed2'],
            ['linear-icon-return' => 'return'],
            ['linear-icon-return2' => 'return2'],
            ['linear-icon-refund' => 'refund'],
            ['linear-icon-history' => 'history'],
            ['linear-icon-history2' => 'history2'],
            ['linear-icon-self-timer' => 'self-timer'],
            ['linear-icon-clock' => 'clock'],
            ['linear-icon-clock2' => 'clock2'],
            ['linear-icon-clock3' => 'clock3'],
            ['linear-icon-watch' => 'watch'],
            ['linear-icon-alarm2' => 'alarm2'],
            ['linear-icon-alarm-add2' => 'alarm-add2'],
            ['linear-icon-alarm-remove' => 'alarm-remove'],
            ['linear-icon-alarm-check' => 'alarm-check'],
            ['linear-icon-alarm-error' => 'alarm-error'],
            ['linear-icon-timer' => 'timer'],
            ['linear-icon-timer-crossed' => 'timer-crossed'],
            ['linear-icon-timer2' => 'timer2'],
            ['linear-icon-timer-crossed2' => 'timer-crossed2'],
            ['linear-icon-download' => 'download'],
            ['linear-icon-upload' => 'upload'],
            ['linear-icon-download2' => 'download2'],
            ['linear-icon-upload2' => 'upload2'],
            ['linear-icon-enter-up' => 'enter-up'],
            ['linear-icon-enter-down' => 'enter-down'],
            ['linear-icon-enter-left' => 'enter-left'],
            ['linear-icon-enter-right' => 'enter-right'],
            ['linear-icon-exit-up' => 'exit-up'],
            ['linear-icon-exit-down' => 'exit-down'],
            ['linear-icon-exit-left' => 'exit-left'],
            ['linear-icon-exit-right' => 'exit-right'],
            ['linear-icon-enter-up2' => 'enter-up2'],
            ['linear-icon-enter-down2' => 'enter-down2'],
            ['linear-icon-enter-vertical' => 'enter-vertical'],
            ['linear-icon-enter-left2' => 'enter-left2'],
            ['linear-icon-enter-right2' => 'enter-right2'],
            ['linear-icon-enter-horizontal' => 'enter-horizontal'],
            ['linear-icon-exit-up2' => 'exit-up2'],
            ['linear-icon-exit-down2' => 'exit-down2'],
            ['linear-icon-exit-left2' => 'exit-left2'],
            ['linear-icon-exit-right2' => 'exit-right2'],
            ['linear-icon-cli' => 'cli'],
            ['linear-icon-bug' => 'bug'],
            ['linear-icon-code' => 'code'],
            ['linear-icon-file-code' => 'file-code'],
            ['linear-icon-file-image' => 'file-image'],
            ['linear-icon-file-zip' => 'file-zip'],
            ['linear-icon-file-audio' => 'file-audio'],
            ['linear-icon-file-video' => 'file-video'],
            ['linear-icon-file-preview' => 'file-preview'],
            ['linear-icon-file-charts' => 'file-charts'],
            ['linear-icon-file-stats' => 'file-stats'],
            ['linear-icon-file-spreadsheet' => 'file-spreadsheet'],
            ['linear-icon-link' => 'link'],
            ['linear-icon-unlink' => 'unlink'],
            ['linear-icon-link2' => 'link2'],
            ['linear-icon-unlink2' => 'unlink2'],
            ['linear-icon-thumbs-up' => 'thumbs-up'],
            ['linear-icon-thumbs-down' => 'thumbs-down'],
            ['linear-icon-thumbs-up2' => 'thumbs-up2'],
            ['linear-icon-thumbs-down2' => 'thumbs-down2'],
            ['linear-icon-thumbs-up3' => 'thumbs-up3'],
            ['linear-icon-thumbs-down3' => 'thumbs-down3'],
            ['linear-icon-share' => 'share'],
            ['linear-icon-share2' => 'share2'],
            ['linear-icon-share3' => 'share3'],
            ['linear-icon-magnifier' => 'magnifier'],
            ['linear-icon-file-search' => 'file-search'],
            ['linear-icon-find-replace' => 'find-replace'],
            ['linear-icon-zoom-in' => 'zoom-in'],
            ['linear-icon-zoom-out' => 'zoom-out'],
            ['linear-icon-loupe' => 'loupe'],
            ['linear-icon-loupe-zoom-in' => 'loupe-zoom-in'],
            ['linear-icon-loupe-zoom-out' => 'loupe-zoom-out'],
            ['linear-icon-cross' => 'cross'],
            ['linear-icon-menu' => 'menu'],
            ['linear-icon-list' => 'list'],
            ['linear-icon-list2' => 'list2'],
            ['linear-icon-list3' => 'list3'],
            ['linear-icon-menu2' => 'menu2'],
            ['linear-icon-list4' => 'list4'],
            ['linear-icon-menu3' => 'menu3'],
            ['linear-icon-exclamation' => 'exclamation'],
            ['linear-icon-question' => 'question'],
            ['linear-icon-check' => 'check'],
            ['linear-icon-cross2' => 'cross2'],
            ['linear-icon-plus' => 'plus'],
            ['linear-icon-minus' => 'minus'],
            ['linear-icon-percent' => 'percent'],
            ['linear-icon-chevron-up' => 'chevron-up'],
            ['linear-icon-chevron-down' => 'chevron-down'],
            ['linear-icon-chevron-left' => 'chevron-left'],
            ['linear-icon-chevron-right' => 'chevron-right'],
            ['linear-icon-chevrons-expand-vertical' => 'chevrons-expand-vertical'],
            ['linear-icon-chevrons-expand-horizontal' => 'chevrons-expand-horizontal'],
            ['linear-icon-chevrons-contract-vertical' => 'chevrons-contract-vertical'],
            ['linear-icon-chevrons-contract-horizontal' => 'chevrons-contract-horizontal'],
            ['linear-icon-arrow-up' => 'arrow-up'],
            ['linear-icon-arrow-down' => 'arrow-down'],
            ['linear-icon-arrow-left' => 'arrow-left'],
            ['linear-icon-arrow-right' => 'arrow-right'],
            ['linear-icon-arrow-up-right' => 'arrow-up-right'],
            ['linear-icon-arrows-merge' => 'arrows-merge'],
            ['linear-icon-arrows-split' => 'arrows-split'],
            ['linear-icon-arrow-divert' => 'arrow-divert'],
            ['linear-icon-arrow-return' => 'arrow-return'],
            ['linear-icon-expand' => 'expand'],
            ['linear-icon-contract' => 'contract'],
            ['linear-icon-expand2' => 'expand2'],
            ['linear-icon-contract2' => 'contract2'],
            ['linear-icon-move' => 'move'],
            ['linear-icon-tab' => 'tab'],
            ['linear-icon-arrow-wave' => 'arrow-wave'],
            ['linear-icon-expand3' => 'expand3'],
            ['linear-icon-expand4' => 'expand4'],
            ['linear-icon-contract3' => 'contract3'],
            ['linear-icon-notification' => 'notification'],
            ['linear-icon-warning' => 'warning'],
            ['linear-icon-notification-circle' => 'notification-circle'],
            ['linear-icon-question-circle' => 'question-circle'],
            ['linear-icon-menu-circle' => 'menu-circle'],
            ['linear-icon-checkmark-circle' => 'checkmark-circle'],
            ['linear-icon-cross-circle' => 'cross-circle'],
            ['linear-icon-plus-circle' => 'plus-circle'],
            ['linear-icon-circle-minus' => 'circle-minus'],
            ['linear-icon-percent-circle' => 'percent-circle'],
            ['linear-icon-arrow-up-circle' => 'arrow-up-circle'],
            ['linear-icon-arrow-down-circle' => 'arrow-down-circle'],
            ['linear-icon-arrow-left-circle' => 'arrow-left-circle'],
            ['linear-icon-arrow-right-circle' => 'arrow-right-circle'],
            ['linear-icon-chevron-up-circle' => 'chevron-up-circle'],
            ['linear-icon-chevron-down-circle' => 'chevron-down-circle'],
            ['linear-icon-chevron-left-circle' => 'chevron-left-circle'],
            ['linear-icon-chevron-right-circle' => 'chevron-right-circle'],
            ['linear-icon-backward-circle' => 'backward-circle'],
            ['linear-icon-first-circle' => 'first-circle'],
            ['linear-icon-previous-circle' => 'previous-circle'],
            ['linear-icon-stop-circle' => 'stop-circle'],
            ['linear-icon-play-circle' => 'play-circle'],
            ['linear-icon-pause-circle' => 'pause-circle'],
            ['linear-icon-next-circle' => 'next-circle'],
            ['linear-icon-last-circle' => 'last-circle'],
            ['linear-icon-forward-circle' => 'forward-circle'],
            ['linear-icon-eject-circle' => 'eject-circle'],
            ['linear-icon-crop' => 'crop'],
            ['linear-icon-frame-expand' => 'frame-expand'],
            ['linear-icon-frame-contract' => 'frame-contract'],
            ['linear-icon-focus' => 'focus'],
            ['linear-icon-transform' => 'transform'],
            ['linear-icon-grid' => 'grid'],
            ['linear-icon-grid-crossed' => 'grid-crossed'],
            ['linear-icon-layers' => 'layers'],
            ['linear-icon-layers-crossed' => 'layers-crossed'],
            ['linear-icon-toggle' => 'toggle'],
            ['linear-icon-rulers' => 'rulers'],
            ['linear-icon-ruler' => 'ruler'],
            ['linear-icon-funnel' => 'funnel'],
            ['linear-icon-flip-horizontal' => 'flip-horizontal'],
            ['linear-icon-flip-vertical' => 'flip-vertical'],
            ['linear-icon-flip-horizontal2' => 'flip-horizontal2'],
            ['linear-icon-flip-vertical2' => 'flip-vertical2'],
            ['linear-icon-angle' => 'angle'],
            ['linear-icon-angle2' => 'angle2'],
            ['linear-icon-subtract' => 'subtract'],
            ['linear-icon-combine' => 'combine'],
            ['linear-icon-intersect' => 'intersect'],
            ['linear-icon-exclude' => 'exclude'],
            ['linear-icon-align-center-vertical' => 'align-center-vertical'],
            ['linear-icon-align-right' => 'align-right'],
            ['linear-icon-align-bottom' => 'align-bottom'],
            ['linear-icon-align-left' => 'align-left'],
            ['linear-icon-align-center-horizontal' => 'align-center-horizontal'],
            ['linear-icon-align-top' => 'align-top'],
            ['linear-icon-square' => 'square'],
            ['linear-icon-plus-square' => 'plus-square'],
            ['linear-icon-minus-square' => 'minus-square'],
            ['linear-icon-percent-square' => 'percent-square'],
            ['linear-icon-arrow-up-square' => 'arrow-up-square'],
            ['linear-icon-arrow-down-square' => 'arrow-down-square'],
            ['linear-icon-arrow-left-square' => 'arrow-left-square'],
            ['linear-icon-arrow-right-square' => 'arrow-right-square'],
            ['linear-icon-chevron-up-square' => 'chevron-up-square'],
            ['linear-icon-chevron-down-square' => 'chevron-down-square'],
            ['linear-icon-chevron-left-square' => 'chevron-left-square'],
            ['linear-icon-chevron-right-square' => 'chevron-right-square'],
            ['linear-icon-check-square' => 'check-square'],
            ['linear-icon-cross-square' => 'cross-square'],
            ['linear-icon-menu-square' => 'menu-square'],
            ['linear-icon-prohibited' => 'prohibited'],
            ['linear-icon-circle' => 'circle'],
            ['linear-icon-radio-button' => 'radio-button'],
            ['linear-icon-ligature' => 'ligature'],
            ['linear-icon-text-format' => 'text-format'],
            ['linear-icon-text-format-remove' => 'text-format-remove'],
            ['linear-icon-text-size' => 'text-size'],
            ['linear-icon-bold' => 'bold'],
            ['linear-icon-italic' => 'italic'],
            ['linear-icon-underline' => 'underline'],
            ['linear-icon-strikethrough' => 'strikethrough'],
            ['linear-icon-highlight' => 'highlight'],
            ['linear-icon-text-align-left' => 'text-align-left'],
            ['linear-icon-text-align-center' => 'text-align-center'],
            ['linear-icon-text-align-right' => 'text-align-right'],
            ['linear-icon-text-align-justify' => 'text-align-justify'],
            ['linear-icon-line-spacing' => 'line-spacing'],
            ['linear-icon-indent-increase' => 'indent-increase'],
            ['linear-icon-indent-decrease' => 'indent-decrease'],
            ['linear-icon-text-wrap' => 'text-wrap'],
            ['linear-icon-pilcrow' => 'pilcrow'],
            ['linear-icon-direction-ltr' => 'direction-ltr'],
            ['linear-icon-direction-rtl' => 'direction-rtl'],
            ['linear-icon-page-break' => 'page-break'],
            ['linear-icon-page-break2' => 'page-break2'],
            ['linear-icon-sort-alpha-asc' => 'sort-alpha-asc'],
            ['linear-icon-sort-alpha-desc' => 'sort-alpha-desc'],
            ['linear-icon-sort-numeric-asc' => 'sort-numeric-asc'],
            ['linear-icon-sort-numeric-desc' => 'sort-numeric-desc'],
            ['linear-icon-sort-amount-asc' => 'sort-amount-asc'],
            ['linear-icon-sort-amount-desc' => 'sort-amount-desc'],
            ['linear-icon-sort-time-asc' => 'sort-time-asc'],
            ['linear-icon-sort-time-desc' => 'sort-time-desc'],
            ['linear-icon-sigma' => 'sigma'],
            ['linear-icon-pencil-line' => 'pencil-line'],
            ['linear-icon-hand' => 'hand'],
            ['linear-icon-pointer-up' => 'pointer-up'],
            ['linear-icon-pointer-right' => 'pointer-right'],
            ['linear-icon-pointer-down' => 'pointer-down'],
            ['linear-icon-pointer-left' => 'pointer-left'],
            ['linear-icon-finger-tap' => 'finger-tap'],
            ['linear-icon-fingers-tap' => 'fingers-tap'],
            ['linear-icon-reminder' => 'reminder'],
            ['linear-icon-fingers-crossed' => 'fingers-crossed'],
            ['linear-icon-fingers-victory' => 'fingers-victory'],
            ['linear-icon-gesture-zoom' => 'gesture-zoom'],
            ['linear-icon-gesture-pinch' => 'gesture-pinch'],
            ['linear-icon-fingers-scroll-horizontal' => 'fingers-scroll-horizontal'],
            ['linear-icon-fingers-scroll-vertical' => 'fingers-scroll-vertical'],
            ['linear-icon-fingers-scroll-left' => 'fingers-scroll-left'],
            ['linear-icon-fingers-scroll-right' => 'fingers-scroll-right'],
            ['linear-icon-hand2' => 'hand2'],
            ['linear-icon-pointer-up2' => 'pointer-up2'],
            ['linear-icon-pointer-right2' => 'pointer-right2'],
            ['linear-icon-pointer-down2' => 'pointer-down2'],
            ['linear-icon-pointer-left2' => 'pointer-left2'],
            ['linear-icon-finger-tap2' => 'finger-tap2'],
            ['linear-icon-fingers-tap2' => 'fingers-tap2'],
            ['linear-icon-reminder2' => 'reminder2'],
            ['linear-icon-gesture-zoom2' => 'gesture-zoom2'],
            ['linear-icon-gesture-pinch2' => 'gesture-pinch2'],
            ['linear-icon-fingers-scroll-horizontal2' => 'fingers-scroll-horizontal2'],
            ['linear-icon-fingers-scroll-vertical2' => 'fingers-scroll-vertical2'],
            ['linear-icon-fingers-scroll-left2' => 'fingers-scroll-left2'],
            ['linear-icon-fingers-scroll-right2' => 'fingers-scroll-right2'],
            ['linear-icon-fingers-scroll-vertical3' => 'fingers-scroll-vertical3'],
            ['linear-icon-border-style' => 'border-style'],
            ['linear-icon-border-all' => 'border-all'],
            ['linear-icon-border-outer' => 'border-outer'],
            ['linear-icon-border-inner' => 'border-inner'],
            ['linear-icon-border-top' => 'border-top'],
            ['linear-icon-border-horizontal' => 'border-horizontal'],
            ['linear-icon-border-bottom' => 'border-bottom'],
            ['linear-icon-border-left' => 'border-left'],
            ['linear-icon-border-vertical' => 'border-vertical'],
            ['linear-icon-border-right' => 'border-right'],
            ['linear-icon-border-none' => 'border-none'],
            ['linear-icon-ellipsis' => 'ellipsis'],
        ];
    }
    add_filter('vc_iconpicker-type-linearicons', 'urna_tbay_linearicons_array');
}

if (!function_exists('urna_tbay_vc_iconpicker_base_register_css')) {
    /*
     * Register Backend and Frontend CSS Styles
     */
    add_action('vc_base_register_front_css', 'urna_tbay_vc_iconpicker_base_register_css');
    add_action('vc_base_register_admin_css', 'urna_tbay_vc_iconpicker_base_register_css');
    function urna_tbay_vc_iconpicker_base_register_css()
    {
        wp_register_style('simple-line-icons', URNA_STYLES.'/simple-line-icons.css', [], '2.4.0');
        wp_register_style('linearicons', URNA_STYLES.'/linearicons.css', [], '1.0.0');
    }
}

if (!function_exists('urna_tbay_vc_iconpicker_editor_jscss')) {
    /*
     * Enqueue Backend and Frontend CSS Styles
     */
    add_action('vc_backend_editor_enqueue_js_css', 'urna_tbay_vc_iconpicker_editor_jscss');
    add_action('vc_frontend_editor_enqueue_js_css', 'urna_tbay_vc_iconpicker_editor_jscss');
    function urna_tbay_vc_iconpicker_editor_jscss()
    {
        wp_enqueue_style('simple-line-icons');
        wp_enqueue_style('linearicons');
        wp_deregister_style('font-awesome');
        wp_enqueue_style('font-awesome', URNA_STYLES.'/font-awesome.css', [], '4.7.0');
    }
}

if (!function_exists('urna_tbay_enqueue_font_icomoon')) {
    /*
     * Enqueue CSS in Frontend when it's used
     */
    add_action('vc_enqueue_font_icon_element', 'urna_tbay_enqueue_font_icomoon');
    function urna_tbay_enqueue_font_icomoon($font)
    {
        switch ($font) {
            case 'simpleline': wp_enqueue_style('simple-line-icons');
            // no break
            case 'linearicons': wp_enqueue_style('linearicons');
        }
    }
}
