<?php
/**
 * functions for Urna Core
 *
 * @package    urna-core
 * @author     Team Thembays <urnathemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  2015-2016 Urna Core
 */
if (!function_exists('tbay_framework_admin_redux_scripts')) {
    function tbay_framework_admin_redux_scripts()
    {
        wp_enqueue_style('tbay-framework-admin', URNA_CORE_URL . 'assets/backend.css');
    }
    add_action('admin_enqueue_scripts', 'tbay_framework_admin_redux_scripts');
}

if ( !function_exists('urna_core_register_widgets_theme') ) {
    function urna_core_register_widgets_theme() {
          
        $widgets = array(
                        'Urna_Widget_Twitter', 
                        'Urna_Widget_Facebook_Like_Box', 
                        'Urna_Widget_Banner_Image',
                        'Urna_Widget_Custom_Menu',
                        'Urna_Widget_List_Categories',
                        'Urna_Widget_Popular_Post',
                        'Urna_Widget_Popup_Newsletter',
                        'Urna_Widget_Posts',
                        'Urna_Widget_Recent_Comment',
                        'Urna_Widget_Recent_Post',
                        'Urna_Widget_Single_Image',
                        'Urna_Widget_Socials',
                        'Urna_Widget_Top_Rate',
                        'Urna_Widget_Featured_Video'
                    );

        if( defined( 'YITH_WCBR' ) && YITH_WCBR ) {
          array_push($widgets,'Urna_Widget_Yith_Brand_Images');
        }        

        if ( class_exists( 'WooCommerce' ) ) {
          array_push($widgets,'Urna_Widget_Woo_Carousel');
        }

        $widgets = apply_filters( 'urna_core_register_widgets_theme', $widgets);


        foreach ($widgets as $widget) {
            if(class_exists($widget)) {
                register_widget( $widget );
            }   
        }
                    
    }

    add_action( 'widgets_init', 'urna_core_register_widgets_theme', 30 );
}

if( ! function_exists( 'urna_core_register_post_types' ) ) {
    function urna_core_register_post_types() {

        $types = array(
            'custom-post',
            'header', 
            'footer', 
            'megamenu',
            'brand', 
            'testimonial', 
            'customtab'
        );

        $post_types = apply_filters( 'urna_core_register_post_types', $types);
        if ( !empty($post_types) ) {
            foreach ($post_types as $post_type) {
                if ( file_exists( URNA_CORE_DIR . 'classes/post-types/'.$post_type.'.php' ) ) {
                    require URNA_CORE_DIR . 'classes/post-types/'.$post_type.'.php';
                }
            }
        }
    }
}

if( ! function_exists( 'urna_core_widget_init' ) ) {
    function urna_core_widget_init() {
    	$widgets = apply_filters( 'urna_core_register_widgets', array() );
    	if ( !empty($widgets) ) {
    		foreach ($widgets as $widget) {
    			if ( file_exists( URNA_CORE_DIR . 'classes/widgets/'.$widget.'.php' ) ) {
    				require URNA_CORE_DIR . 'classes/widgets/'.$widget.'.php';
    			}
    		}
    	}
    }
}

if( ! function_exists( 'urna_core_get_widget_locate' ) ) {
    function urna_core_get_widget_locate( $name, $plugin_dir = URNA_CORE_DIR ) {
    	$template = '';
    	
    	// Child theme
    	if ( ! $template && ! empty( $name ) && file_exists( get_stylesheet_directory() . "/widgets/{$name}" ) ) {
    		$template = get_stylesheet_directory() . "/widgets/{$name}";
    	}

    	// Original theme
    	if ( ! $template && ! empty( $name ) && file_exists( get_template_directory() . "/widgets/{$name}" ) ) {
    		$template = get_template_directory() . "/widgets/{$name}";
    	}

    	// Plugin
    	if ( ! $template && ! empty( $name ) && file_exists( $plugin_dir . "/templates/widgets/{$name}" ) ) {
    		$template = $plugin_dir . "/templates/widgets/{$name}";
    	}

    	// Nothing found
    	if ( empty( $template ) ) {
    		throw new Exception( "Template /templates/widgets/{$name} in plugin dir {$plugin_dir} not found." );
    	}

    	return $template;
    }
}


if( ! function_exists( 'urna_core_remove_image_srcset' ) ) {
    function urna_core_remove_image_srcset( $media_item ) {
        add_filter( 'wp_calculate_image_srcset', '__return_false' );
    }
    add_action( 'init', 'urna_core_remove_image_srcset', 10 );
}


if( ! function_exists( 'urna_core_product_add_metaboxes' ) ) {
    add_action( 'add_meta_boxes', 'urna_core_product_add_metaboxes', 50 );
    function urna_core_product_add_metaboxes() {

        if( function_exists( 'urna_size_guide_metabox_output' ) ) {
            //Add metaboxes size guide to product
            add_meta_box( 'woocommerce-product-size-guide-images', esc_html__( 'Product Size Guide (Only Variable product)', 'urna-core' ), 'urna_size_guide_metabox_output', 'product', 'side', 'low' );
        }       

        if( function_exists( 'urna_swatch_attribute_template' ) ) {
            add_meta_box( 'woocommerce-product-swatch-attribute', esc_html__( 'Swatch attribute to display', 'urna-core' ), 'urna_swatch_attribute_template', 'product', 'side' );    
        }    

        if( function_exists( 'urna_single_select_single_layout_template' ) ) {
            add_meta_box( 'woocommerce-product-single-layout', esc_html__( 'Select Single Product Layout', 'urna-core' ), 'urna_single_select_single_layout_template', 'product', 'side' );  
        }

    }
}

if ( !function_exists( 'urna_core_fix_customize_image_wvs_support' ) ) {
    function urna_core_fix_customize_image_wvs_support(){
        remove_filter( 'pre_update_option_woocommerce_thumbnail_image_width', 'wvs_clear_transient' );
        remove_filter( 'pre_update_option_woocommerce_thumbnail_cropping', 'wvs_clear_transient' );
    }
    add_action('admin_init', 'urna_core_fix_customize_image_wvs_support', 10);
}

if ( !function_exists( 'urna_core_register_urna_manager_submenu' ) ) {
    add_action('admin_menu', 'urna_core_register_urna_manager_submenu');
    function urna_core_register_urna_manager_submenu() {
        add_menu_page( 
            'Urna Manager', 
            'Urna Custom Post Manager', 
            'manage_options', 
            'urna_manager',
            '',
            'dashicons-layout',
            50
        );
    }
}

if ( !function_exists( 'urna_core_render_template' ) ) {
    add_shortcode( 'urna_block', 'urna_core_render_template', 10 );
    function urna_core_render_template( $atts ) {
        $atts = shortcode_atts(
            [
                'id' => '',
            ],
            $atts,
            'urna_block'
        );

        $slug = ! empty( $atts['id'] ) ? apply_filters( 'urna_render_template_id', $atts['id'] ) : '';

        

        if ( empty( $slug ) ) {
            return '';
        }

        if ( $post = get_page_by_path( $slug, OBJECT, 'tbay_custom_post' ) ) {
            $id = $post->ID;
        } else {
            return false;
        }

        if ( class_exists( '\Elementor\Plugin' ) && Elementor\Plugin::instance()->documents->get( $id )->is_built_with_elementor() ) {
            if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
                $css_file = new \Elementor\Core\Files\CSS\Post( $id );
            } elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
                // Load elementor styles.
                $css_file = new \Elementor\Post_CSS_File( $id );
            }

            $css_file->enqueue();

            return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $id );
        } else {
            $content_post = get_post($id);
            $content = $content_post->post_content;
            return do_shortcode($content);
        }

    }
}